<?php
/*  Terminkalender - Version 26.11.2010

 * Der Server, auf dem der Terminkalender gespeichert ist, muss die Programmier-
    sprache PHP (Version: 4/5) untersttzen.

 * Die Datei "termine.txt" bentigt die Schreibrechte Chmod 700
    Mehr dazu unter: http://www.homepage-total.de/php/chmod.php

 * Der Editor wird vom Internet Explorer ab Version 7 unterstzt.

 Funktionen:
 + Termine in diesem Monat werden gelb markiert, Der aktuelle Termin (heute) wird
    rot markiert und ein abgelaufener Termin wird grau markiert.
 + Termine werden beim anzeigen autom. nach dem Datum (aufsteigend) sortiert.
 + Suchfunktion mit Filter  * Kalender  * Druckansicht.
 + Statusanzeige der Datei. * Viele Einstellmglichkeiten.
 + Einfgen einer URL (wird automatisch als Link formatiert).
 + Es sind mehrere Passwrter, fr verschiedene Benutzer, mglich.
 + Falsche oder abgelaufene Datumsangaben werden nicht eingetragen.
 + Tabellenzeilen weden beim berfahren mit dem Mauszeiger eingefrbt.
 + Beim anklicken eines Datums werden alle Termine mit dem gleichen Datum markiert.
 + Beim anklicken eines Radio-Buttons wird der aktuelle Termin in das Formular eingefgt.
 + Abgelaufene Termine knnen ausgeblendet werden (Liste, Druckansicht)
 + "Zusatz"-Eingabefeld (den Namen kann man, hier in den Einstellungen, ndern)
 +  Nutzbar als Eventkalender, Aufgabenliste, Linkliste, Tagebuch, Datenbank und vieles mehr.

 Eine aktuelle Version finden Sie unter: www.homepage-total.de/php/terminkalender.php

 Es wird kein Support fr Probleme gegeben, die bei der Anpassung der Scripts entstehen.
 Verbesserungsvorschlge und Hinweise senden Sie an:
 webmaster@homepage-total.de (Mit dem Betreff: Terminkalender)

Vielen Dank an R. Heidemeier der mir eine Anleitung zum Terminkalender und 
zahlreiche Ideen geliefert hat.

 Werner Zenk -  www.homepage-total.de
 Das Script darf frei genutzt werden, solange dieser Text nicht entfernt wird! */



/* Tipps zum einbinden des Terminkalenders

Passen Sie das Design (Farbe, Hintergrund, ...) an Ihre Website an.
Weitere Farbeinstellungen knnen Sie hier vornehmen.
Einbinden mit iFrame: <iframe src="kalender.php" width="400" height="600" frameborder="0" scrolling="auto"></iframe>
Einbinden mit include <?php include("kalender.php"); ?> oder <?php include("liste.php"); ?>
Vergessen Sie bei include nicht die HTML-Tags <head><title> <body> ... zu entfernen, 
nicht das diese dann zweimal im HTML-Dokument vorhanden sind! */




/* Hier knnen Sie die Einstellungen vornehmen.
Wenn Sie etwas gendert haben, schauen Sie gleich nach 
ob die nderung funktioniert, gegebenenfalls knnen Sie diese 
wieder rckgngig machen. */

/* Hier das Passwort eintragen
Mehrere Passwrter durch ein Komma trennen (zum Beispiel: "user,sunny,mayr") */
$passwort = "user";


$termindatei = "termine.txt"; // Die Datei "termine.txt" bentigt Schreibrechte


$terminkalender = "Terminkalender"; // Name der berschrift


/* Link zum Editor (Eintrge bearbeiten) anzeigen */
$link_termine_bearbeiten = "ja"; // ja/nein


/* Abgelaufene Eintrge (Termine) in der Liste und in der Druckansicht anzeigen */
$abgelaufener_termin = "ja"; // ja/nein


/* Name fr das "Beschreibung"-Feld */
$name_beschreibung = "Beschreibung"; // Zum Beispiel: Veranstaltung, Mannschaft, Event, ...


/* Name fr das "Zusatz"-Feld */
$name_zusatz = "Zusatz"; // Zum Beispiel: Uhr, Spielstand, Club, Liga, Kategorie, ...


/* Name fr das "Ort"-Feld */
$name_ort = "Ort"; // Zum Beispiel: Veranstaltungsort, Link, ...


/* Name fr das "Prioritt"-Feld */
$name_prioritaet = "Priorit&auml;t"; // Zum Beispiel: Punkte, Bewertung, ...


/* Format des Datums (Vor dem gewnschten Format die Kommentarzeichen // am Anfang entfernen) */
$datumsformat = "%d.%m.%Y"; // %d.%m.%Y (Anzeige: 24.12.2009)
// $datumsformat = "%a., %d %b. %Y"; // %a., %d %b. %Y (Anzeige: Do., 24 Dez. 2009)
// $datumsformat = "%A, %d %B %Y"; // %A, %d %B %Y (Anzeige: Donnerstag, 24 Dezember 2009)


/* Farbe der Tabelle
 Eine bersicht an Farben finden Sie unter:
 http://homepage-total.de/html/farbnamen.php
 */
$tabellenkopf_hintergrund = "#7AAACD"; // #7AAACD
$zellenhintergrund_hell = "#FCFCFC"; // #FCFCFC
$zellenhintergrund_dunkel = "#DEECEF"; // #DEECEF
$zellenhintergrund_highlight = "#FFFF97; padding: 5px;"; // #FFFF97
$zellenhintergrund_suche = "#B9FFB9"; // #B9FFB9


/* Farbe der Eingabefelder und der Buttons */
$eingabefeld = "border: Solid 1px #7AAACD;"; // border: Solid 1px #7AAACD;
$button = "background-color: #7AAACD; border: Solid 1px #326485;"; // background-color: #7AAACD; border: Solid 1px #326485;


/* Farbe der Ereignismeldung, Statusmeldung und Fehlermeldung */
$ereignismeldung = "#0000DD;"; // #0000DD;
$statusmeldung = "#00A000;"; // #00A000;
$fehlermeldung = "#EE0000;"; // #EE0000;


/* Farbe der Pfeile (Sortierung) */
$pfeil_sortierung = "color: #F4F4F4; text-decoration: None;"; // color: #F4F4F4; text-decoration: None;


/* Zeichenbegrenzung bei der Texteingabe (Dadurch ndert sich die Breite der Tabelle!) */
$begrenze_beschreibung = 1000; // Beschreibung (Maximal) ein lngerer Text wird abgeschnitten.
$begrenze_beschreibung_min = 10; // Beschreibung (Minimal) ein krzerer Text wird nicht eingetragen.
$begrenze_zusatzfeld = 50; // Zusatzfeld (Maximal) ein lngerer Text wird abgeschnitten.
$begrenze_ort = 20; // Ort (Maximal) ein lngerer Text wird abgeschnitten.
$begrenze_ort_min = 3; // Ort (Minimal) ein krzerer Text wird nicht eingetragen.
$zeilenumbruch_beschreibung = 75; // Zeilenumbruch nach 75 Zeichen


/* Zeichenbegrenzung bei der "Anzeige der Beschreibung" im Editor.
 Hilfreich um die bersicht in der Tabelle bei langen Beschreibungen zu behalten! */
$editor_beschreibung_kuerzen = "nein"; // ja/nein
$editor_beschreibung_zahl = 35; // Anzahl der Zeichen


/* Prioritt (Vor dem gewnschten Format die Kommentarzeichen // am Anfang entfernen) */
 $prioritaetext = array("1", "2", "3"); // Prioritt (Zahlen)  // "1", "2", "3"
// $prioritaetext = array("1", "2", "3", "4", "5", "6", "7", "8", "9", "10"); // Prioritt (Zahlen) Wichtig: Auch Variable $prioritaetcss anpassen!
// $prioritaetext = array("&bull;", "&bull;&bull;", "&bull;&bull;&bull;"); // Prioritt (Punkte) // "&bull;", "&bull;&bull;", "&bull;&bull;&bull;"

$prioritaetcss = array("#5D5D5D", "#7171FF", "#FF4AA5"); // Farben der Prioritt // "#5D5D5D", "#7171FF", "#FF4AA5"
// $prioritaetcss = array("#5D5D5D", "#7171FF", "#FF4AA5", "#FF8000", "#00FF00", "#FF00FF", "#8080C0", "#CE6700", "#6A00D5", "#ACAC59"); // Farben der Prioritt

/* Markierung des Datums */
$aktueller_monat = "border-left: Solid 5px #FFD700;"; // Aktueller Monat // border-left: Solid 5px #FFD700;
$aktueller_tag = "border-left: Solid 5px #FF0000;"; // Aktueller Tag // border-left: Solid 5px #FF0000;
$abgelaufener_tag = "border-left: Solid 5px #999999;"; // Abgelaufener Tag // border-left: Solid 5px #999999;


/* Legende der Markierung */
$markierung = <<<EOT
<p><small>&nbsp; &nbsp; <span style="$aktueller_tag">&nbsp;Aktueller Tag</span>&nbsp;
<span style="$aktueller_monat">&nbsp;Aktueller Monat</span>&nbsp;
<span style="$abgelaufener_tag">&nbsp;Abgelaufener Tag</span></small></p>
EOT;

/* Funktionen */
function datum_markieren($tag, $monat, $jahr) {
 global $aktueller_monat, $aktueller_tag, $abgelaufener_tag;
 $a = "border-left: Solid 4px Transparent;"; // Keine Markierung!
 if (mktime(0, 0, 0, date("m"), date("Y")) == mktime(0, 0, 0, $monat, $jahr)) {
  $a = $aktueller_monat;
 }
 if (mktime(0, 0, 0, date("m"), date("d"), date("Y")) == mktime(0, 0, 0, $monat, $tag, $jahr)) {
  $a = $aktueller_tag;
 }
 if (mktime(0, 0, 0, date("m"), date("d"), date("Y")) > mktime(0, 0, 0, $monat, $tag, $jahr)) {
  $a = $abgelaufener_tag;
 }
 return $a;
}

function termin_abgelaufen($tag, $monat, $jahr, $abgelaufener_termin) {
 if ($abgelaufener_termin != "ja") {
  if (mktime(0, 0, 0, date("m"), date("d"), date("Y")) > mktime(0, 0, 0, $monat, $tag, $jahr)) {
   return ' display: none;';
  }
 }
}

error_reporting(0); // Keine Fehlermeldungen anzeigen

// Lokale Formate
date_default_timezone_set('Europe/Berlin');
setLocale(LC_ALL, "de_DE", "german");
?>