<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Terminkalender - Liste</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<style type="text/css">
body, a, td, th {
 font-family: Verdana, Arial; font-size: 11px;
}

a, a:visited {
 color: #DD0000;
}
</style>

</head>
<body>

<!-- Terminkalender - Termine
 Das Script stammt von Werner Zenk
 Homepage: www.homepage-total.de
 E-Mail: webmaster@homepage-total.de
 Das Script darf frei genutzt werden,
 solange dieser Text nicht entfernt wird! -->

<?php
// Terminkalender - Termine

require_once("einstellungen.inc.php");

$diese_datei = basename($_SERVER["SCRIPT_NAME"]);
$filterc =  isset($_POST["filter"]) ? ' checked="checked"' : "";
$suche = isset($_POST["suche"]) ? $_POST["suche"] : "";

echo <<<EOT
<form action="$diese_datei" method="post">
<table border="0" cellpadding="2" cellspacing="1">
<caption><b>$terminkalender</b>  
<input type="text" name="suche" size="18" value="$suche" style="$eingabefeld">
<input type="submit" value="Suchen" style="$button">
<input type="checkbox" name="filter"$filterc id="marke" /> <label for="marke"><small>Filter</small></label>
</caption>
EOT;

$termin = array();
if (file_exists($termindatei)) {
 $dateiinhalt = file($termindatei);
}
else {
 exit("<strong>Die Datei \"$termindatei\" ist nicht vorhanden!</strong>");
}

sort($dateiinhalt);

foreach ($dateiinhalt as $element) {
 list($a, $b, $c, $d, $e, $f) = explode("|", $element);
 $termin[] = array("Datum" => $a, "Beschreibung" => $b, "Zusatz" => $c, "Ort" => $d, "Prioritt" => $e, "ID" => $f);
}
foreach ($termin as $nr => $inhalt) {
 $datum[$nr] = strtolower($inhalt["Datum"]);
 $ort[$nr] = strip_tags(strtolower($inhalt["Ort"]));
 $beschreibung[$nr] = strtolower($inhalt["Beschreibung"]);
 $zusatzfeld[$nr] = strtolower($inhalt["Zusatz"]);
 $prioritaet[$nr] = $inhalt["Prioritt"];
 $id[$nr] = strtolower($inhalt["ID"]);
}

if (isset($_GET["sortierung"])) {
 if (count($dateiinhalt) > 0) {
  switch ($_GET["sortierung"]) {
   case("d"):
    array_multisort($datum, $zusatzfeld, SORT_ASC, $termin);
    break;
   case("da"):
    array_multisort($datum, SORT_DESC, $termin);
    break;
   case("b"):
    array_multisort($beschreibung, SORT_ASC, $termin);
    break;
   case("ba"):
    array_multisort($beschreibung, SORT_DESC, $termin);
    break;
   case("z"):
    array_multisort($zusatzfeld, SORT_ASC, $termin);
    break;
   case("za"):
    array_multisort($zusatzfeld, SORT_DESC, $termin);
    break;
   case("o"):
    array_multisort($ort, SORT_ASC, $termin);
    break;
   case("oa"):
    array_multisort($ort, SORT_DESC, $termin);
    break;
   case("p"):
    array_multisort($prioritaet, SORT_ASC, $termin);
    break;
   case("pa"):
    array_multisort($prioritaet, SORT_DESC, $termin);
    break;
   default:
    array_multisort($datum, SORT_ASC, $ort, SORT_ASC, $termin);
  }
 }
}

if (isset($_REQUEST["suche"])) {
 echo "<tr><td colspan=\"3\"><span style=\"color: " . ((!empty($_REQUEST["suche"])) ? 
 ((!isset($_GET["suche"])) ?
 "$statusmeldung\"><strong>Suchbegriff:</strong> <em>&thinsp;$_REQUEST[suche]</em> " :
 "$statusmeldung\">Datum markieren...") :
 "#FF0000;\">Geben Sie einen Suchbegriff ein!") . "</span></td></tr>";
}

echo <<<EOT
\n<tr style="background-color: $tabellenkopf_hintergrund;">
<th nowrap="nowrap">
Datum <a href="$diese_datei?sortierung=da" style="$pfeil_sortierung" title="Absteigend nach Datum sortieren">&nabla;</a> 
<a href="$diese_datei?sortierung=d" style="$pfeil_sortierung" title="Aufsteigend nach Datum sortieren">&Delta;</a>
</th>
<th nowrap="nowrap">
$name_beschreibung <a href="$diese_datei?sortierung=ba" style="$pfeil_sortierung" title="Absteigend nach $name_beschreibung sortieren">&nabla;</a> 
<a href="$diese_datei?sortierung=b" style="$pfeil_sortierung" title="Aufsteigend nach $name_beschreibung sortieren">&Delta;</a>
</th>
<th nowrap="nowrap">
$name_zusatz <a href="$diese_datei?sortierung=za" style="$pfeil_sortierung" title="Absteigend nach $name_zusatz sortieren">&nabla;</a> 
<a href="$diese_datei?sortierung=z" style="$pfeil_sortierung" title="Aufsteigend nach $name_zusatz sortieren">&Delta;</a>
</th>
<th nowrap="nowrap">
$name_ort <a href="$diese_datei?sortierung=oa" style="$pfeil_sortierung" title="Absteigend nach $name_ort sortieren">&nabla;</a> 
<a href="$diese_datei?sortierung=o" style="$pfeil_sortierung" title="Aufsteigend nach $name_ort sortieren">&Delta;</a>
</th>
<th nowrap="nowrap">
$name_prioritaet <a href="$diese_datei?sortierung=pa" style="$pfeil_sortierung" title="Absteigend nach $name_prioritaet sortieren">&nabla;</a> 
<a href="$diese_datei?sortierung=p" style="$pfeil_sortierung" title="Aufsteigend nach $name_prioritaet sortieren">&Delta;</a>
</th>
EOT;

if (isset($_POST["filter"])) {
 if ($_POST["suche"] !="") {
  foreach ($termin as $zaehler => $inhalt) {
   if (!stristr($dateiinhalt[$zaehler], $_POST["suche"])) {
    unset($termin[$zaehler]);
   }
  }
 }
}

foreach ($termin as $zeilenr => $inhalt) {
 $farbe = (($zeilenr % 2) ? $zellenhintergrund_dunkel : $zellenhintergrund_hell);
 if (isset($_REQUEST["suche"])) {
  if (!empty($_REQUEST["suche"])) {
   $farbe = ((stristr($dateiinhalt[$zeilenr], $_REQUEST["suche"])) ? $zellenhintergrund_suche : $farbe);
  }
 }
 list($jahr, $monat, $tag) = explode(".", $inhalt["Datum"]);
 echo  "<tr style=\"background-color: $farbe;" . termin_abgelaufen($tag, $monat, $jahr, $abgelaufener_termin) . "\" onMouseOver=\"this.style.backgroundColor='$zellenhintergrund_highlight';\" onMouseOut=\"this.style.backgroundColor='$farbe';\">\n";
 echo "<td style=\"" . datum_markieren($tag, $monat, $jahr) . "font-weight: bold; cursor: pointer;\" title=\"Datum markieren\" onClick=\"location.href='$diese_datei?suche=$jahr.$monat.$tag';\">";
 echo strftime($datumsformat, mktime(0, 0, 0, $monat, $tag, $jahr)) . "</td>\n";
 echo "<td>" . wordwrap($inhalt["Beschreibung"], $zeilenumbruch_beschreibung, "<br>") . "</td>\n";
 echo "<td>" . $inhalt["Zusatz"] . "</td>\n";
 echo "<td>" . $inhalt["Ort"] . "</td>\n";
 echo "<th> <span style=\"color: " . $prioritaetcss[$inhalt["Prioritt"]] . ";\">" . $prioritaetext[$inhalt["Prioritt"]] . "</span></th>\n";
 echo "</tr>\n";
}
echo "</table>\n</form>\n";
echo $markierung;
echo <<<EOT
<a href="kalender.php">Kalender</a> | 
<a href="druckansicht.php?filter=$suche" target="_blank">Druckansicht</a>
EOT;
echo $link_termine_bearbeiten == "ja" ? " | <a href=\"editor.php\" title=\"Eintr&auml;ge bearbeiten\">Editor</a>" : "";
?>


</body>
</html>