<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<title>Terminkalender - Druckansicht</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<style type="text/css">
body, a, td, th {
 font-family: Verdana, Arial; font-size: 11px;
}

a, a:visited {
 color: #DD0000;
}
</style>

</head>
<body>

<!-- Terminkalender - Druckansicht
 Das Script stammt von Werner Zenk
 Homepage: www.homepage-total.de
 E-Mail: webmaster@homepage-total.de
 Das Script darf frei genutzt werden,
 solange dieser Text nicht entfernt wird! -->

<?php
// Terminkalender - Druckansicht

require_once("einstellungen.inc.php");

if (file_exists($termindatei)) {
 $dateiinhalt = file($termindatei);
}
else {
 exit("<strong>Die Datei \"$termindatei\" ist nicht vorhanden!</strong>");
}

sort($dateiinhalt);

echo <<<TABELLE
<table border="1" cellpadding="2" cellspacing="0">
<caption> <strong>$terminkalender</strong></caption>
<tr style="background-color: #DFDFDF;">
<th>Datum</th>
<th>$name_beschreibung</th>
<th>$name_zusatz</th>
<th>$name_ort</th>
<th>$name_prioritaet</th>
TABELLE;

if (isset($_GET["filter"])) {
 if ($_GET["filter"] != "") {
  foreach ($dateiinhalt as $zaehler => $element) {
   if (!stristr($element, $_GET["filter"])) {
    unset($dateiinhalt[$zaehler]);
   }
  }
 }
}

foreach ($dateiinhalt as $element) {
 list($datum, $beschreibung, $name_zusatz, $ort, $prioritaet, $id) = explode("|", $element);
 list($jahr, $monat, $tag) = explode(".", $datum);
 echo  "<tr style=\"" . termin_abgelaufen($tag, $monat, $jahr, $abgelaufener_termin) . "\">\n" .
  "<td style=\"" . datum_markieren($tag, $monat, $jahr) . "font-weight: bold;\">" .
  strftime($datumsformat, mktime(0, 0, 0, $monat, $tag, $jahr)) . "</td>\n" .
  "<td>" . wordwrap($beschreibung, $zeilenumbruch_beschreibung, "<br>") . "</td>\n" .
  "<td>" . $name_zusatz . "&thinsp;</td>\n" .
  "<td>" . $ort . "</td>\n" .
  "<th> <span style=\"color: " . $prioritaetcss[$prioritaet] . ";\">" . $prioritaetext[$prioritaet] . "</span></th>\n" .
  "</tr>\n";
}
echo "</table>\n" . $markierung;
?>

</body>
</html>